/*
 * Decompiled with CFR 0.152.
 */
package com.android.invoice.domain.use_case.invoice.post;

import com.android.invoice.domain.model.ADtlVarietyDto;
import com.android.invoice.domain.model.AInvoiceDtlDto;
import com.android.order.domain.model.AOrderDtlDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class InsertADtlVarieties {
    private final DbConnection dbConnection;

    public void invoke(List<ADtlVarietyDto> varietyList, AInvoiceDtlDto dtl) {
        if (ConvertStr.isNullOrEmpty(varietyList)) {
            return;
        }
        StringBuilder insertSql = new StringBuilder("INSERT INTO ItemFact(FAC_CODE, FAC_TYPE, A_INDEX, PoshakIDF, Few, SelPriceId, A_Code) VALUES \n");
        for (ADtlVarietyDto variety : varietyList) {
            insertSql.append("(").append(this.getFacCode(dtl)).append(", ").append("'").append(dtl.getType().getInvoiceTypeForVariety()).append("', ").append(dtl.getRowIndex()).append(", ").append(variety.getVarietyIDF()).append(", ").append(variety.getAmount()).append(", ").append(variety.getSelPriceID() == null ? 1L : variety.getSelPriceID()).append(", '").append(variety.getProductCode()).append("'").append("), \n");
        }
        this.dbConnection.getJdbcTemplate().update(ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)insertSql, (String)",").toString());
    }

    private String getFacCode(AInvoiceDtlDto dtl) {
        if (dtl.getType().isOrder()) {
            return "dbo.ProducCode('" + dtl.getInvoiceId() + "')";
        }
        return "'" + dtl.getInvoiceId() + "'";
    }

    public void invoke(List<ADtlVarietyDto> varietyList, AOrderDtlDto dtl) {
        this.invoke(varietyList, AInvoiceDtlDto.builder().invoiceId(String.valueOf(dtl.getOrderId())).type(dtl.getType()).rowIndex(Integer.valueOf(dtl.getRowNumber())).build());
    }

    public InsertADtlVarieties(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

